/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.target;

import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.target.Target;
import com.ibm.hwmca.fw.target.TargetActionListener;
import com.ibm.hwmca.fw.target.TargetRetriever;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ActionDescriptor;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskSelectionEvent;
import com.ibm.ui.framework.TaskSelectionListener;
import com.ibm.ui.framework.UserTaskManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class TargetBean
implements DataBean,
TaskActionListener,
TaskSelectionListener,
Serializable {
    private static final String TRACE_MASKT = "XCMTBENT";
    private static final String TRACE_MASKF = "XCMTBENF";
    private static final String TRACE_MASKD = "XCMTBEND";
    private ItemDescriptor[] m_idTargetTable;
    private ItemDescriptor[][] m_idTargetColumns;
    private ColumnDescriptor[] m_cdTargetTableStructure;
    private int[] m_iTargetTableSelection;
    private UserTaskManager utm;
    private TargetRetriever retriever;
    private int type;
    private String taskid;
    private Target[] selectedTargets = null;
    private boolean disposed = false;
    private Target[] targets = null;
    private HashMap menuMap = new HashMap();
    private HashMap actionMap = new HashMap();
    private HashMap typeMap = new HashMap();
    private TargetActionListener targetActionListener = null;

    public TargetBean(TargetRetriever retriever, String taskid, int type) {
        this.retriever = retriever;
        this.taskid = taskid;
        this.type = type;
    }

    public ColumnDescriptor[] getTargetTableRowStructure() {
        LocalizableText[] headers;
        if (this.m_cdTargetTableStructure == null && (headers = this.retriever.getColumnHeaders(this.taskid)) != null && headers.length > 0) {
            this.m_cdTargetTableStructure = new ColumnDescriptor[headers.length];
            int i = 0;
            while (i < headers.length) {
                this.m_cdTargetTableStructure[i] = new ColumnDescriptor("ColumnHeader" + i, headers[i].toString(), false);
                ++i;
            }
        }
        return this.m_cdTargetTableStructure;
    }

    public int getTargetTableRowStatus() {
        return 3;
    }

    public int getTargetTableRowCount() {
        int rows = this.m_idTargetTable != null ? this.m_idTargetTable.length : 0;
        return rows;
    }

    public ItemDescriptor[] getTargetTableRowAt(int index) {
        ItemDescriptor[] rowAt = null;
        rowAt = this.m_idTargetColumns == null ? new ItemDescriptor[]{this.m_idTargetTable[index]} : this.m_idTargetColumns[index];
        return rowAt;
    }

    public void setTargetTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idTargetTable[index] = items[0];
    }

    public int[] getTargetTableSelection() {
        Trace.trace(TRACE_MASKF, "<> TargetBean.getTargetTableSelection()");
        return this.m_iTargetTableSelection;
    }

    public void setTargetTableSelection(int[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "-> TargetBean.setTargetTableSelection()");
        this.m_iTargetTableSelection = new int[selected.length];
        int i = 0;
        while (i < selected.length) {
            this.m_iTargetTableSelection[i] = selected[i];
            ++i;
        }
        Trace.trace(TRACE_MASKF, "<- TargetBean.setTargetTableSelection()");
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void setUserTaskManager(UserTaskManager utm) {
        this.utm = utm;
    }

    public void load() {
        Trace.trace(TRACE_MASKF, "-> TargetBean.load()");
        this.targets = this.retriever.getTargets(this.taskid, null);
        if (this.targets != null) {
            this.m_idTargetTable = new ItemDescriptor[this.targets.length];
            LocalizableText[] headers = this.retriever.getColumnHeaders(this.taskid);
            if (headers != null && headers.length > 0) {
                this.m_idTargetColumns = new ItemDescriptor[this.targets.length][];
            }
            int i = 0;
            while (i < this.targets.length) {
                this.m_idTargetTable[i] = new ItemDescriptor("Target_" + String.valueOf(i), this.targets[i].getName().toString().replace('\n', ':'));
                if (this.m_idTargetColumns != null) {
                    LocalizableText[] colData = this.targets[i].getColumnData();
                    if (colData != null && colData.length > 0) {
                        this.m_idTargetColumns[i] = new ItemDescriptor[colData.length];
                        int j = 0;
                        while (j < colData.length) {
                            this.m_idTargetColumns[i][j] = new ItemDescriptor("Target_Column" + String.valueOf(i) + "_" + String.valueOf(j), colData[j].toString().replace('\n', ' '));
                            ++j;
                        }
                    } else {
                        this.m_idTargetColumns[i] = new ItemDescriptor[]{this.m_idTargetTable[i]};
                    }
                }
                ++i;
            }
        } else {
            this.m_idTargetTable = null;
        }
        Trace.trace(TRACE_MASKF, "-> TargetBean.load #1");
        this.m_iTargetTableSelection = null;
        if (this.type == 1) {
            boolean selectedCount = false;
            boolean actionCount = false;
            Trace.trace(TRACE_MASKF, "-> TargetBean.load #2");
            if (!this.menuMap.isEmpty()) {
                Set keyset = this.menuMap.keySet();
                Iterator i = keyset.iterator();
                while (i.hasNext()) {
                    this.utm.removeAction((String)i.next());
                }
            }
            this.menuMap.clear();
            this.actionMap.clear();
            this.typeMap.clear();
            TargetActionListener[] tal = this.retriever.getActions(this.taskid);
            Trace.trace(TRACE_MASKF, "-> TargetBean.load #3");
            int selCount = 0;
            int genCount = 0;
            if (tal != null) {
                int i = 0;
                while (i < tal.length) {
                    ClassId[] types = tal[i].getAllowedTypes();
                    String actionName = null;
                    String menuName = null;
                    boolean initEnablement = false;
                    if (types == null) {
                        actionName = "GeneralAction" + String.valueOf(++genCount);
                        menuName = "ActionMenu";
                        initEnablement = true;
                    } else {
                        actionName = "SelectedAction" + String.valueOf(++selCount);
                        menuName = "SelectedMenu";
                        initEnablement = false;
                        int j = 0;
                        while (j < types.length) {
                            ArrayList<String> typeList = (ArrayList<String>)this.typeMap.get(types[j]);
                            if (typeList == null) {
                                typeList = new ArrayList<String>();
                                this.typeMap.put(types[j], typeList);
                            }
                            typeList.add(actionName);
                            ++j;
                        }
                    }
                    ActionDescriptor ad = this.buildActionDescriptor(actionName, tal[i]);
                    this.actionMap.put(actionName, tal[i]);
                    this.menuMap.put(actionName, tal[i]);
                    this.utm.addAction(menuName, null, ad);
                    this.utm.setEnabled(actionName, initEnablement);
                    ++i;
                }
            }
            Trace.trace(TRACE_MASKF, "-> TargetBean.load #4");
            if (genCount == 0) {
                this.utm.setShown("ActionMenu", false);
            } else {
                this.utm.setShown("ActionMenu", true);
            }
            if (selCount == 0) {
                this.utm.setShown("SelectedMenu", false);
            } else {
                this.utm.setShown("SelectedMenu", true);
                if (!this.actionMap.isEmpty()) {
                    Set keyset = this.actionMap.keySet();
                    Iterator i = keyset.iterator();
                    while (i.hasNext()) {
                        String name = (String)i.next();
                        if (!name.startsWith("SelectedAction")) continue;
                        Trace.trace(TRACE_MASKF, "disabling selected menu item [" + name + "]");
                        this.utm.setEnabled(name, false);
                    }
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<- TargetBean.load()");
    }

    private ActionDescriptor buildActionDescriptor(String actionName, TargetActionListener tal) {
        Trace.trace(TRACE_MASKF, "-> TargetBean.buildActionDescriptor(" + actionName + "," + tal + ")");
        ActionDescriptor ad = new ActionDescriptor(actionName, tal.getActionName().toString());
        TargetActionListener[] subTal = tal.getSubActions();
        if (subTal != null) {
            ActionDescriptor[] subActions = new ActionDescriptor[subTal.length];
            int j = 0;
            while (j < subTal.length) {
                String subActionName = actionName + "-" + String.valueOf(j);
                subActions[j] = this.buildActionDescriptor(subActionName, subTal[j]);
                this.actionMap.put(subActionName, subTal[j]);
                ClassId[] types = subTal[j].getAllowedTypes();
                if (types != null) {
                    int i = 0;
                    while (i < types.length) {
                        ArrayList<String> typeList = (ArrayList<String>)this.typeMap.get(types[i]);
                        if (typeList == null) {
                            typeList = new ArrayList<String>();
                            this.typeMap.put(types[i], typeList);
                        }
                        typeList.add(subActionName);
                        ++i;
                    }
                }
                ++j;
            }
            ad.setSubactions(subActions);
        }
        Trace.trace(TRACE_MASKF, "<- TargetBean.buildActionDescriptor()");
        return ad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(TaskActionEvent evt) {
        Trace.trace(TRACE_MASKF, "-> TargetBean.actionPerformed()");
        String command = evt.getActionCommand();
        Trace.trace(TRACE_MASKF, "command=[" + command + "]");
        if (command.equals("CANCEL") || command.equals("CancelButton")) {
            this.utm.dispose();
            this.selectedTargets = null;
            TargetBean targetBean = this;
            synchronized (targetBean) {
                this.disposed = true;
                this.notifyAll();
            }
        } else if (command.equals("RefreshButton")) {
            this.load();
            this.utm.refreshAllElements();
        } else if (command.equals("OKButton") || command.startsWith("GeneralAction") || command.startsWith("SelectedAction")) {
            this.utm.storeAllElements();
            if (this.m_iTargetTableSelection != null) {
                this.selectedTargets = new Target[this.m_iTargetTableSelection.length];
                int i = 0;
                while (i < this.selectedTargets.length) {
                    this.selectedTargets[i] = this.targets[this.m_iTargetTableSelection[i]];
                    ++i;
                }
            } else {
                this.selectedTargets = null;
            }
            this.targetActionListener = !command.equals("OKButton") ? (TargetActionListener)this.actionMap.get(command) : null;
            this.utm.dispose();
            TargetBean targetBean = this;
            synchronized (targetBean) {
                this.disposed = true;
                this.notifyAll();
            }
        } else {
            Trace.trace(TRACE_MASKF, "unknown action [" + command + "]");
        }
        Trace.trace(TRACE_MASKF, "<- TargetBean.actionPerformed()");
    }

    public void selectionChanged(TaskSelectionEvent evt) {
        Trace.trace(TRACE_MASKF, "-> TargetBean.selectionChanged(" + evt.getElementName() + ")");
        if (this.type == 1) {
            if ("TargetTable".equals(evt.getElementName())) {
                ClassId[] selectedTypes;
                int[] selRows = this.utm.getSelectedRows("TargetTable");
                if (selRows != null && selRows.length > 0) {
                    HashMap types = new HashMap();
                    int i = 0;
                    while (i < selRows.length) {
                        ItemDescriptor[] items = this.getTargetTableRowAt(selRows[i]);
                        if (items != null && items.length > 0) {
                            Trace.trace(TRACE_MASKF, "Item: " + items[0].getTitle() + " is currently selected");
                        }
                        ObjectId id = this.targets[selRows[i]].getObjectId();
                        Trace.trace(TRACE_MASKF, "adding type [" + id.getClassId() + " to selected type map");
                        types.put(id.getClassId(), null);
                        ++i;
                    }
                    selectedTypes = new ClassId[types.size()];
                    Set keyset = types.keySet();
                    int index = 0;
                    Iterator i2 = keyset.iterator();
                    while (i2.hasNext()) {
                        selectedTypes[index] = (ClassId)i2.next();
                        ++index;
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "No rows currently selected");
                    selectedTypes = new ClassId[]{};
                }
                if (!this.typeMap.isEmpty() && !this.actionMap.isEmpty()) {
                    Set keyset = this.actionMap.keySet();
                    Iterator i = keyset.iterator();
                    while (i.hasNext()) {
                        String name = (String)i.next();
                        if (!name.startsWith("SelectedAction")) continue;
                        Trace.trace(TRACE_MASKF, "checking selected menu item [" + name + "]");
                        int validTypeCount = 0;
                        int j = 0;
                        while (j < selectedTypes.length) {
                            Trace.trace(TRACE_MASKF, "checking selected type [" + selectedTypes[j] + "]");
                            TargetActionListener tal = (TargetActionListener)this.actionMap.get(name);
                            if (tal != null) {
                                ClassId[] allowedTypes = tal.getAllowedTypes();
                                int k = 0;
                                while (k < allowedTypes.length) {
                                    Trace.trace(TRACE_MASKF, "checking allowed type [" + allowedTypes[k] + "]");
                                    if (selectedTypes[j].equals(allowedTypes[k])) {
                                        ++validTypeCount;
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                        if (selectedTypes.length > 0 && validTypeCount == selectedTypes.length) {
                            Trace.trace(TRACE_MASKF, "enabling selected menu item [" + name + "]");
                            this.utm.setEnabled(name, true);
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "disabling selected menu item [" + name + "]");
                        this.utm.setEnabled(name, false);
                    }
                }
            }
        } else {
            int[] selRows;
            boolean enable = false;
            if ("TargetTable".equals(evt.getElementName()) && (selRows = this.utm.getSelectedRows("TargetTable")) != null && selRows.length > 0) {
                enable = true;
            }
            this.utm.setEnabled("OKButton", enable);
        }
        Trace.trace(TRACE_MASKF, "<- TargetBean.selectionChanged()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Target[] getTargets() {
        Trace.trace(TRACE_MASKF, "-> TargetBean.getTargets()");
        TargetBean targetBean = this;
        synchronized (targetBean) {
            while (!this.disposed) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<- TargetBean.getTargets()");
        return this.selectedTargets;
    }

    public TargetActionListener getTargetActionListener() {
        return this.targetActionListener;
    }
}

